<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


/**
* description
*
* @library	
* @author	
* @since	
*/
class CPage extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		$this->name = "page";
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;
		parent::DoEvents();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function RenderPage($tpl = null) {
		global $_TSM;

		$this->__init();

		if (!$tpl) {
			$tpl = $this->_t("main");
		}

		//get the backgrounds for this page
		if ($this->plugins["globalhooks"]->module_data) {
			if ($this->plugins["globalhooks"]->module_data["mod_id"]) {
				$bgs = $this->plugins["backgrounds"]->GetPageBgs($this->plugins["globalhooks"]->module_data["mod_id"]);
			} else {
				$bgs = $this->plugins["backgrounds"]->GetPageBgs($this->plugins["globalhooks"]->module_data["module_id"]);
			}			
		} 

		//page background
		$bg_page = $bg_title = $bg_foot = $bg_main = array("html" => "" , "class" => "");
		if (is_array($bgs["1"])) {
			$bg_page = $this->plugins["backgrounds"]->GetBg($bgs["1"]);
		}

		//page title background
		if (is_array($bgs["2"])) {
			$bg_title = $this->plugins["backgrounds"]->GetBg($bgs["2"]);
		}

		//menu background
		$bg_header = array(
			//main menu
			"main_html"				=> "",
			"main_class"			=> "",
			"main_scheme"			=> "{BG:SCHEME}",

			"main_sticky_html"		=> "",
			"main_sticky_class"		=> "",
			"main_sticky_scheme"	=> "{BG:SCHEME}",

			"main_collapse_html"	=> "",
			"main_collapse_class"	=> "",
			"main_collapse_scheme"	=> "{BG:SCHEME}",

			//secondary menu
			"sec_html"				=> "",
			"sec_class"				=> "",
			"sec_scheme"			=> "{BG:SCHEME}",

			"sec_collapse_html"		=> "",
			"sec_collapse_class"	=> "",
			"sec_collapse_scheme"	=> "{BG:SCHEME}",
		
			//menu bar
			"bar_collapse_html"		=> "",
			"bar_collapse_class"	=> "{BG:SCHEME}",

			//normal menu
			"header_bg_class"		=> "{BG:SCHEME}",
			"header_bg_html"		=> "",

			//sticky menu
//				"header_sticky_bg_html"		=> str_replace("background " , "background background-sticky " , $bg_menu_sticky["html"]),
			"header_sticky_bg_html"		=> "",
			"header_sticky_bg_class"	=> "{BG:SCHEME}",
		);

		if (is_array($bgs[3])) {

			$bg_menu				= $this->plugins["backgrounds"]->GetBg($bgs["3"]["bg_background"]);
			$bg_menu_sticky			= str_replace("background " , "background background-sticky " , $this->plugins["backgrounds"]->GetBg($bgs["3"]["bg_background_sticky"]));
			$bg_menu_sec			= $this->plugins["backgrounds"]->GetBg($bgs["3"]["bg_background_sec"]);
			
			$bg_menu_collapse_main	= $this->plugins["backgrounds"]->GetBg($bgs["3"]["bg_background_collapse_main"]);
			$bg_menu_collapse_sec	= $this->plugins["backgrounds"]->GetBg($bgs["3"]["bg_background_collapse_sec"]);
			$bg_menu_collapse_btn	= str_replace("background " , "background background-collapsed " , $this->plugins["backgrounds"]->GetBg($bgs["3"]["bg_background_collapse_bar"]));


			//inherit scheme
			if (!$bg_menu["bg:scheme"]) {
				$bg_menu["bg:scheme"] = "{BG:SCHEME}";
			}

			//inherit scheme
			if (!$bg_menu_sec["bg:scheme"]) {
				$bg_menu_sec["bg:scheme"] = "{BG:SCHEME}";
			}
			
			//inherit scheme from normal
			if (!$bg_menu_collapse_main["bg:scheme"]) {
				$bg_menu_collapse_main["bg:scheme"] = $bg_menu["bg:scheme"];
			}

			if (!$bg_menu_collapse_sec["bg:scheme"]) {
				$bg_menu_collapse_sec["bg:scheme"] = $bg_menu_sec["bg:scheme"];
			}

			$bg_header = array(

				//main menu
				"main_html"				=> $bg_menu["html"],
				"main_class"			=> $bg_menu["class"],
				"main_scheme"			=> $bg_menu["bg:scheme"],

				"main_sticky_html"		=> $bg_menu_sticky["html"],
				"main_sticky_class"		=> $bg_menu_sticky["class"],
				"main_sticky_scheme"	=> $bg_menu_sticky["bg:scheme"],

				"main_collapse_html"	=> $bg_menu_collapse_main["html"],
				"main_collapse_class"	=> $bg_menu_collapse_main["class"],
				"main_collapse_scheme"	=> $bg_menu_collapse_main["bg:scheme"],

				//secondary menu
				"sec_html"				=> $bg_menu_sec["html"],
				"sec_class"				=> $bg_menu_sec["class"],
				"sec_scheme"			=> $bg_menu_sec["bg:scheme"],

				"sec_collapse_html"		=> $bg_menu_collapse_sec["html"],
				"sec_collapse_class"	=> $bg_menu_collapse_sec["class"],
				"sec_collapse_scheme"	=> $bg_menu_collapse_sec["bg:scheme"],
			
				//menu bar
				"bar_collapse_html"		=> $bg_menu_collapse_btn["html"],
				"bar_collapse_class"	=> $bg_menu_collapse_btn["class"],

				//normal menu
				"header_bg_class"		=> $bg_menu["class"],
				"header_bg_html"		=> $bg_menu["html"],

				//sticky menu
//				"header_sticky_bg_html"		=> str_replace("background " , "background background-sticky " , $bg_menu_sticky["html"]),
				"header_sticky_bg_html"		=> $bg_menu_sticky["html"],
				"header_sticky_bg_class"	=> $bg_menu_sticky["class"],
			);

		} else {
			$bg_menu = array(
				"html"			=> "",
				"html_sticky"	=> ""
			);
		}


		//footer background
		if (is_array($bgs["4"])) {
			$bg_foot= $this->plugins["backgrounds"]->GetBg($bgs["4"]);
		}

		//main tag background
		if (is_array($bgs["5"])) {
			$bg_main = $this->plugins["backgrounds"]->GetBg($bgs["5"]);
		}
		
		//debug($page_bg);
		//debug($bgs,1);
		
		//debug($this->plugins["menus"]->Menus(),1);

		$menus = $this->plugins["menus"]->Menus();

		return $tpl->blockREplace(
			"Page",
			array(

				"_menu"		=> ($menus[1]["content"] || $menus[2]["content"]) ? $tpl->blockReplace(
					"Menu",
					array(
						"_top_menu"		=> CTemplateStatic::Replace(
							$menus[1]["content"],
							$bg_menu
						),
						"_sec_menu"		=> CTemplateStatic::Replace(
							$menus[2]["content"],
							$bg_menu_sec
						),
						"_sec_button"	=> $menus[2]["trigger"],
						"_top_button"	=> $menus[1]["trigger"],
					),
					$bg_menu,
					$bg_header
				) : "",

				"_main"		=> $tpl->blockReplace(
					"Main" , 
					array(
						"_breadcrumb"	=> CTemplateStatic::Replace(
							$this->plugins["breadcrumb"]->Render(),
							$bg_title
						)
					),
					$bg_main
				),


				"_footer"	=> $tpl->blockReplace(
					"Footer",
					array(
						"_content"		=> $this->plugins["layouts"]->footerLayout(),
						"_copyright"	=> $this->plugins["skineditor"]->copyrightBar()
					),
					$bg_foot

				),

				"page:html"		=> $bg_page["html"],
				"page:class"	=> $bg_page["class"],
				
			),
			$_TSM,
			//final fallback
			array(
				"bg:scheme"		=> "nc"
			)
		);

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"main"	=> "main.htm"
		);

		if (count($templates)) {
			foreach ($templates as $key => $val) {
				$this->private->templates[$key] = new CTemplateDynamic(
					$path . $val 
				);
			}
		}
	} 

}
